; -----------------------------------------------------------------------------
; #############################################################################
; -----------------------------------------------------------------------------
; Name:               QuickChangeDir
; -----------------------------------------------------------------------------
; Prefix:             qc_
; Version:            0.4
; Date:               2005-04-27
; Author:             Wolfgang Reszel fr c't
; Copyright:          2005 Heise Zeitschriften Verlag GmbH & Co. KG
; -----------------------------------------------------------------------------

; -----------------------------------------------------------------------------
; === Initialisation ==========================================================
; -----------------------------------------------------------------------------
   Process, Priority,, B
   SetBatchLines,0

   ; Programmname und Version
   ScriptName    = QuickChangeDir
   ScriptVersion = 0.4
   qc_Titel = %ScriptName% v%ScriptVersion%

   StringReplace,activAidDir,A_Workingdir,\extensions,

   ; Welche Laufwerke sollen bercksichtigt werden?
   IniRead, qc_PathsToIndex, %activAidDir%\settings\ac'tivAid.ini, QuickChangeDir, PathsToIndex, C:\

   IniRead, Lng, %activAidDir%\settings\ac'tivAid.ini, activAid, Language
   If Lng = ERROR
      StringRight, Lng, A_Language, 2 ; Sprache ermitteln, wenn nicht in INI festgelegt

   ; Wo werden die Verzeichnisindexe gespeichert
   IniRead, qc_IndexPath, %activAidDir%\settings\ac'tivAid.ini, QuickChangeDir, IndexPath
   If (qc_IndexPath = "ERROR" OR qc_IndexPath ="")
      qc_IndexPath = %activAidDir%\settings\%ScriptName%

   IniRead, qc_NoBalloonTips, %activAidDir%\settings\ac'tivAid.ini, QuickChangeDir, NoBalloonTips, 0

   qc_IndexFile = QCD_Index_

   if 1 <>
      qc_PathsToIndex = %1%

   qc_selectedDrives = %qc_PathsToIndex%


   if Lng = 07  ; = Deutsch (0407, 0807, 0c07 ...)
   {
      lng_qc_Untersuche             = Untersuche
      lng_qc_Indiziere              = Erstelle Verzeichnisindex
      lng_qc_ReIndizierungBreak     = &Aktualisierung abbrechen
      lng_qc_ReIndizierungPause     = Aktualisierung an&halten
      lng_qc_ReIndizierungFortsetzen= Aktualisierung &fortsetzen
   }
   else        ; = andere Sprachen
   {
      lng_qc_Untersuche             = Looking at drive
      lng_qc_Indiziere              = Creating directorylist
      lng_qc_ReIndizierung          = &update directorylist
      lng_qc_ReIndizierungBreak     = &cancel updating
      lng_qc_ReIndizierungPause     = &pause updating
      lng_qc_ReIndizierungFortsetzen= co&ntinue updating
   }

   Menu, Tray, NoStandard
   Menu, Tray, Add, %lng_qc_ReIndizierungPause%, qc_Pause
   Menu, Tray, Add, %lng_qc_ReIndizierungBreak%, qc_Exit

; ---------------------------------------------------------------------
; -- Laufwerke indizieren ---------------------------------------------
; ---------------------------------------------------------------------
   If qc_BreakIndexing = IndexingActiv ; Wenn Indizierung im Gange
   {
      qc_BreakIndexing = yes           ; Indizierung abbrechen (Aufruf kam also vom Traymen)
      Return                            ; und nicht weiter machen
   }
   If qc_BreakIndexing =               ; Wenn Indizierung nicht im Gange
      qc_BreakIndexing = IndexingActiv ; Status setzen

   ; Alle Schaltflchen bis auf "Abbrechen" deaktivieren
   GuiControl, 9:Disable, Button1
   GuiControl, 9:Disable, Button3
   GuiControl, 9:Disable, Button4
   GuiControl, 9:Disable, ListBox1

   ; Sprechblase, dass die Indizierung beginnt
   If ( qc_NoBalloonTips <> 1 )
      TrayTip, %qc_Titel%, %lng_qc_Indiziere%`n%qc_selectedDrives% %qc_2%,10,1

   ; Alle Laufwerksbuchstaben durchgehen
   Loop, Parse, qc_selectedDrives, `,
   {
      If A_LoopField =
         break

      qc_ActDrive := qc_func_GetDrive( A_LoopField ) ; Aktuelles Laufwerk
      qc_ActPath = %A_LoopField%
      StringRight, qc_RightChar, qc_ActPath, 1
      If qc_RightChar = \
         StringTrimRight, qc_ActPath, qc_ActPath, 1
      qc_IndexTemp  = %qc_IndexPath%\%qc_IndexFile%%qc_ActDrive%_tmp.dat ; Temporrer Index

      ; Tooltip fr das Trayicon ndern
      Menu,tray,Tip, %qc_Titel%`n%lng_qc_Untersuche% %qc_ActPath%

      ; Laufwerk durchgehen und Verzeichnisse in Verzeichnisindex schreiben
      qc_AllPaths =
      Loop, %qc_ActPath%\*.* , 2, 1
      {
         qc_AllPaths = %qc_AllPaths%%A_LoopFileFullPath%`n ; in Verzeichnisindex in Variable schreiben

         if (Mod(A_Index,31) = 0)
         {
            Menu, TRAY, Tip, %qc_Titel%`n%lng_qc_Untersuche% %qc_ActPath% (%A_Index%)
            qc_IconDelay  = 150                ; Animation erzwingen
            gosub, qc_sub_Animate                  ; Trayicon animieren
         }
         gosub, qc_sub_Animate                     ; Trayicon animieren
         If qc_BreakIndexing = yes             ; Abbruch?
            break
      }

      ;FileMove, %qc_IndexTemp%, %qc_IndexDest%,1 ; Verzeichnisindex durch temporren Index ersetzen
      If qc_BreakIndexing = yes                   ; Abbruch?
        break

      FileAppend, %qc_AllPaths%, %qc_IndexTemp%
   }

   ; Temporre Index-Dateien aktivieren
   Loop, Parse, qc_selectedDrives, `,
   {
      If A_LoopField =
         continue

      qc_ActDrive := qc_func_GetDrive( A_LoopField ) ; Aktuelles Laufwerk
      qc_ActPath = %A_LoopField%
      StringRight, qc_RightChar, qc_ActPath, 1
      If qc_RightChar = \
         StringTrimRight, qc_ActPath, qc_ActPath, 1
      FileMove, %qc_IndexPath%\%qc_IndexFile%%qc_ActDrive%_tmp.dat, %qc_IndexPath%\%qc_IndexFile%%qc_ActDrive%.dat, 1
      DriveSpaceFree, qc_actSpace, % qc_func_GetDrive( A_LoopField, "RealPath" )
      IniWrite, %qc_actSpace%, %qc_IndexPath%\%qc_IndexFile%Data.ini, Drives, %qc_ActDrive%
   }

   Suspend,Off
   TrayTip                      ; Sprechblase entfernen
   qc_BreakIndexing =          ; Indizierung beendet

   ; Tooltip zurcksetzen
   Menu, TRAY, Tip, %ScriptTitle%
Return

; ---------------------------------------------------------------------
qc_sub_Animate: ;    Animiertes Trayicon und Fenstertitel

   FirstIcon = 3  ; erste IconNr
   LastIcon  = 13 ; letzte IconNr

   ; Verzgerung, damit nich bei jedem Aufruf die Icondateien geladen werden
   ; ansonsten wrde das Skript stark gebremst
   qc_IconDelay++         ; Verzgerungswert
   if qc_IconDelay < 150  ; kleiner 150 ...
      return               ; ... dann Unterroutine verlassen

   qc_IconDelay = 0

   ; IconNr hochzhlen
   qc_TrayIcon++
   If qc_TrayIcon < %FirstIcon%
      qc_TrayIcon = %FirstIcon%
   If qc_TrayIcon > %LastIcon%
      qc_TrayIcon = %FirstIcon%

   ; Icon ndern
   Menu,TRAY,Icon,%SystemRoot%\system32\taskmgr.exe,%qc_TrayIcon%
Return

qc_Exit:
   ; Index-Dateien lschen
   Loop, Parse, qc_selectedDrives, `,
   {
      If A_LoopField =
         break

      qc_ActDrive := qc_func_GetDrive( A_LoopField ) ; Aktuelles Laufwerk
      qc_ActPath = %A_LoopField%
      StringRight, qc_RightChar, qc_ActPath, 1
      If qc_RightChar = \
         StringTrimRight, qc_ActPath, qc_ActPath, 1
      FileDelete, %qc_IndexPath%\%qc_IndexFile%%qc_ActDrive%_tmp.dat
   }

   ExitApp
Return

qc_Pause:
   If Pause =
   {
      Menu, Tray, Rename, %lng_qc_ReIndizierungPause%, %lng_qc_ReIndizierungFortsetzen%
      Pause = 1
      Pause, On
   }
   Else
   {
      Menu, Tray, Rename, %lng_qc_ReIndizierungFortsetzen%, %lng_qc_ReIndizierungPause%
      Pause =
      Pause, Off
   }
Return

qc_func_GetDrive( Path, RealPath = "" )
{
   StringLeft, Drive, Path, 1
   If Drive = \
   {
      StringSplit, Path, Path, \
      If RealPath = RealPath
         Drive = \\%Path3%\%Path4%
      Else
         Drive := func_StrTranslate(Path3 "#" Path4, "-+ !&()'", "______[]_")
   }
   Else If RealPath = RealPath
      Drive = %Drive%:\

   Return %Drive%
}

func_StrTranslate(String,TransFrom,TransTo)
{
   Loop, Parse, TransFrom
   {
      StringMid, TransToChar, TransTo, %A_Index%, 1
      StringReplace, String, String, %A_LoopField%, %TransToChar%, All
   }
   Return %String%
}

